import { Injectable } from '@angular/core';
import { RestaurantBase } from './models/restaurant-base.model';
import { AngularFireDatabase } from '@angular/fire/compat/database';
import { from, Observable } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class RestaurantService {
  private readonly tableName = "/restaurants";

  private readonly restaurants = this.db.database.ref(this.tableName);

  constructor(private readonly db: AngularFireDatabase) {
    // this.restaurants.valueChanges().subscribe((data) => {
    //   alert("s")
    //   console.log(data);
    // })
  }

  add(restaurant: RestaurantBase) {
    return from(this.restaurants.child(restaurant.name).set(restaurant));
  }

  get() {
    return this.db.list(this.tableName).valueChanges();
  }
}
